<aside id="sidebar" class="sidebar">
    <?php
        $admin = App\Models\Admin::where('id', Auth::guard('admin')->user()->id)->first();
    ?>
    <ul class="sidebar-nav" id="sidebar-nav">


        <?php if($admin->hasRole('user')): ?>
        <li class="nav-item">
            <a class="nav-link " href="<?php echo e(url('order/dashboard')); ?>">
                <i class="bi bi-grid"></i>
                <span>Dashboard</span>
            </a>
        </li><!-- End Dashboard Nav -->
        <?php else: ?>
        <li class="nav-item">
            <a class="nav-link " href="<?php echo e(url('admin/dashboard')); ?>">
                <i class="bi bi-grid"></i>
                <span>Dashboard</span>
            </a>
        </li><!-- End Dashboard Nav -->
            <li class="nav-item">
                <a class="nav-link collapsed" data-bs-target="#components-nav" data-bs-toggle="collapse" href="#">
                    <i class="bi bi-box"></i><span>Store</span><i class="bi bi-chevron-down ms-auto"></i>
                </a>
                <ul id="components-nav" class="nav-content collapse " data-bs-parent="#sidebar-nav">

                    <li>
                        <a href="<?php echo e(route('purchases.index')); ?>">
                            <span>Purchase</span>
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('stocks.index')); ?>">
                            <span>Stock</span>
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('suppliers.index')); ?>">
                            <span>Supplier</span>
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('payments.index')); ?>">
                            <span>Payment</span>
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('paymenttypes.index')); ?>">
                            <span>Payment Method</span>
                        </a>
                    </li>
                </ul>
            </li><!-- End Components Nav -->

            <li class="nav-item">
                <a class="nav-link collapsed" data-bs-target="#forms-nav" data-bs-toggle="collapse" href="#">
                    <i class="bi bi-truck"></i><span>Courier</span><i class="bi bi-chevron-down ms-auto"></i>
                </a>
                <ul id="forms-nav" class="nav-content collapse " data-bs-parent="#sidebar-nav">
                    <li>
                        <a href="<?php echo e(route('couriers.index')); ?>">
                            <span>Courier</span>
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('cities.index')); ?>">
                            <span>City</span>
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('zones.index')); ?>">
                            <span>Zone</span>
                        </a>
                    </li>
                </ul>
            </li><!-- End Forms Nav -->
        <?php endif; ?>

        <li class="nav-item">
            <a class="nav-link collapsed" href="<?php echo e(url('admin_order/Processing')); ?>">
                <i class="bi bi-cart"></i>
                <span>Order</span>
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link collapsed" href="<?php echo e(url('admin_order/Pending Invoiced')); ?>">
                <i class="bi bi-file-richtext"></i>
                <span>Invoiced</span>
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link collapsed" href="<?php echo e(url('admin_order/Delivered')); ?>">
                <i class="bi bi-truck-flatbed"></i>
                <span>Delivered</span>
            </a>
        </li>
        <?php if($admin->hasRole('manager') || $admin->hasRole('user')): ?>
            <li class="nav-item">
                <a class="nav-link collapsed" href="<?php echo e(url('order/complain')); ?>">
                    <i class="bi bi-truck-flatbed"></i>
                    <span>Complain</span>
                </a>
            </li>
        <?php else: ?>
        <?php endif; ?>

        <li class="nav-item">
            <a class="nav-link collapsed" href="<?php echo e(url('complain/Pending')); ?>">
                <i class="bi bi-truck-flatbed"></i>
                <span>Complain Box</span>
            </a>
        </li>

        <li class="nav-item">
            <a class="nav-link collapsed" href="<?php echo e(url('/orderby-product')); ?>">
                <i class="bi bi-person"></i>
                <span>Product Orders</span>
            </a>
        </li>

        <?php if($admin->hasRole('manager') || $admin->hasRole('user')): ?>
        <?php else: ?>
            <li class="nav-item">
                <a class="nav-link collapsed" data-bs-target="#tables-nav" data-bs-toggle="collapse" href="#">
                    <i class="bi bi-truck"></i><span>Report</span><i class="bi bi-chevron-down ms-auto"></i>
                </a>
                <ul id="tables-nav" class="nav-content collapse " data-bs-parent="#sidebar-nav">
                    <li>
                        <a href="<?php echo e(route('courieruserreport')); ?>">
                            <span>Courier User Report</span>
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('courierreport')); ?>">
                            <span>Courier Report</span>
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('userreport')); ?>">
                            <span>User Report</span>
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('productreport')); ?>">
                            <span>Product</span>
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('paymentreport')); ?>">
                            <span>Payment</span>
                        </a>
                    </li>
                </ul>
            </li><!-- End Tables Nav -->

            <li class="nav-item">
                <a class="nav-link collapsed" href="<?php echo e(route('orderchange.bybarcode')); ?>">
                    <i class="bi bi-person"></i>
                    <span>OR Scanner</span>
                </a>
            </li>
        <?php endif; ?>


    </ul>

</aside>
<?php /**PATH C:\xampp\htdocs\doom\resources\views/admin/includes/sidebar.blade.php ENDPATH**/ ?>